﻿namespace Microsoft.Samples.PlanMyNight.Infrastructure.Mvc
{
    using System;
    using System.Web;
    using System.Web.Mvc;

    public class HandleErrorWithContentTypeAttribute : HandleErrorAttribute
    {
        public override void OnException(ExceptionContext filterContext)
        {
            if (filterContext == null)
            {
                throw new ArgumentNullException("filterContext");
            }

            if (!filterContext.ExceptionHandled)
            {
                Exception innerException = filterContext.Exception;
                if ((new HttpException(null, innerException).GetHttpCode() == 500) && this.ExceptionType.IsInstanceOfType(innerException))
                {
                    filterContext.ExceptionHandled = true;
                    filterContext.HttpContext.Response.Clear();
                    filterContext.HttpContext.Response.TrySkipIisCustomErrors = true;

                    if (!string.IsNullOrEmpty(filterContext.HttpContext.Request.ContentType) && filterContext.HttpContext.Request.ContentType.Contains("application/json"))
                    {
                        var jsonResult = new JsonResult
                        {
                            JsonRequestBehavior = JsonRequestBehavior.AllowGet,
                            Data = new
                            {
                                Status = "error",
                                Message = "An error has occurred.",
                                RetryUrl = filterContext.HttpContext.Request.Url.ToString(),
                                Details = filterContext.HttpContext.Request.IsLocal ? innerException.ToString() : string.Empty
                            }
                        };

                        filterContext.Result = jsonResult;
                    }
                    else
                    {
                        string controllerName = (string)filterContext.RouteData.Values["controller"];
                        string actionName = (string)filterContext.RouteData.Values["action"];
                        HandleErrorInfo model = new HandleErrorInfo(filterContext.Exception, controllerName, actionName);

                        ViewResult result = new ViewResult();
                        result.ViewName = this.View;
                        result.MasterName = this.Master;
                        result.ViewData = new ViewDataDictionary<HandleErrorInfo>(model);
                        result.TempData = filterContext.Controller.TempData;
                        filterContext.Result = result;
                        filterContext.HttpContext.Response.StatusCode = 500;
                    }
                }
            }
        }
    }
}